#include<vector>
#include<tuple>
#include<iostream>

using namespace std;


std::pair<long long int, long long int> ispitaj(
        const vector<vector<int>>& m,
        int s,
        vector<bool>& poseceniCvorovi,
        const vector<long long int>& novac) {

    int n = poseceniCvorovi.size();
    poseceniCvorovi[s] = true;
    long long int ukupno_sakupljeno = novac[s];
    long long int ukupno_potroseno = 0;

    for (int i=0; i<n; i++) {
        if (m[s][i] == 1 && !poseceniCvorovi[i]) {
            auto p = ispitaj(m, i, poseceniCvorovi, novac);
            ukupno_potroseno += p.first + p.second;
            ukupno_sakupljeno += p.first;
            //r += novac[i] + 2*ispitaj(m, i, poseceniCvorovi, novac);
        }
    }
    return pair<long long int, long long int>(ukupno_sakupljeno, ukupno_potroseno);
}

void zad_banke(const vector<vector<int>>& matSusedstva,
               vector<long long int>& novac,
               const vector<pair<long long int, int>>& transferi) {
    int n = novac.size();
    int m = transferi.size();

    long long int min;
    int indeks_min;
    for (int k=0; k<=m; k++) {
        if (k > 0) {
            int banka_id = transferi[k-1].second - 1; // -1 jer indeksiramo od nule!
            int dodatni_novac = transferi[k-1].first;
            novac[banka_id] += dodatni_novac;
        }
        for (int test_cvor=0; test_cvor < n; test_cvor++) {
            vector<bool> poseceni(n);
            long long int cena = ispitaj(matSusedstva, test_cvor, poseceni, novac).second;
            if (test_cvor == 0) {
                min = cena;
                indeks_min = 0;
            }
            if (cena < min) {
                min = cena;
                indeks_min = test_cvor;
            }
        }
        std::cout << indeks_min+1 << std::endl;
    }

}

int main() {
    int N;
    cin >> N;
    vector<vector<int>> matrica_susedstva(N, vector<int>(N));
    for (int i=0; i < N-1; i++) {
        int p, q;
        std::cin >> p >> q;
        matrica_susedstva[p-1][q-1] = 1;
        matrica_susedstva[q-1][p-1] = 1;
    }
    vector<long long int> novac(N);
    for (int i=0; i < N; i++) {
        std::cin >> novac[i];
    }
    int Q;
    std::cin >> Q;

    vector<pair<long long int, int>> transferi(Q);
    for (int i=0; i < Q; i++) {
        long long int z;
        int b;
        cin >> z >> b;
        transferi[i] = std::pair<long long int, int>(z, b);
    }
    zad_banke(matrica_susedstva, novac, transferi);

    return 0;
}